#!/bin/bash

IMAGE_FILE=$1
gpu_id=$2
PYTHON_PATH_TEST="/home/user/anaconda3/envs/i-blip/bin/python"
PYTHON_PATH_METRIC="/home/user/anaconda3/envs/i-blip/bin/python"

if [ -z "$IMAGE_FILE" ]; then
    echo "Usage: $0 <image_file_path>"
    exit 1
fi
OUTPUT_FILE="${IMAGE_FILE%.pt}.jsonl"
datasets=("Harmbench" "jailbreakbench" "AdvBench" "StrongREJECT" "real-toxicity-prompts")
judges=( "llama_Guard") # "perspective_api" "detoxify" "llama_Guard" "GPT-4o"

# 1. instructblip_inference.py 
echo "Running instructblip_inference.py..."
CUDA_VISIBLE_DEVICES=$gpu_id $PYTHON_PATH_TEST instructblip_inference.py \
    --image_file "$IMAGE_FILE" \
    --datasets "${datasets[@]}"

# 2. get_metric_perspective.py 
echo "Running get_metric.py..."
for dataset in "${datasets[@]}"; do
    OUTPUT_FILE="${IMAGE_FILE%.*}_${dataset}_instructblip.jsonl"
    CUDA_VISIBLE_DEVICES=$gpu_id $PYTHON_PATH_METRIC get_metric.py \
        --input "$OUTPUT_FILE" \
        --output "${OUTPUT_FILE%.jsonl}_eval.jsonl" \
        --judge "${judges[@]}"
done

# 3. cal_metrics_final.py 
echo "Running cal_metrics_final.py..."
for dataset in "${datasets[@]}"; do
    OUTPUT_FILE="${IMAGE_FILE%.*}_${dataset}_instructblip.jsonl"
    CUDA_VISIBLE_DEVICES=$gpu_id $PYTHON_PATH_METRIC cal_metrics_final.py \
        --input "${OUTPUT_FILE%.jsonl}_eval.jsonl" \
        --metrics "${judges[@]}"
done

echo "Pipeline completed!"
